#ifndef _Conversion_CPP
#define _Conversion_CPP
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <StdIO.H>

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void LongCharEx (DWORD dwInput, char *sOutVal)
{
    _ultoa(dwInput, sOutVal, 10);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// This functions return value must be freed externally
char * LongChar (DWORD dwInput)
{
    char *LocalTemp = (char *) calloc(32, sizeof(char));
    LongCharEx(dwInput, LocalTemp);
    return LocalTemp;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void FloatCharEx (float fInput, char *sOutVal)
{
	_gcvt(fInput, 12, sOutVal );
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// This functions return value must be freed externally
char * FloatChar (float fInput)
{
    char *LocalTemp = (char *) calloc(32, sizeof(char));
    FloatCharEx(fInput, LocalTemp);
    return LocalTemp;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void DoubleCharEx (double dInput, char *sOutVal)
{
    sprintf(sOutVal, "%.1f", dInput);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// This functions return value must be freed externally
char * DoubleChar (double dInput)
{
    char *LocalTemp = (char *) calloc(32, sizeof(char));
    DoubleCharEx(dInput, LocalTemp);
    return (LocalTemp);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void IntCharEx (int iInput, char *sOutVal)
{
    _itoa(iInput, sOutVal, 10);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

// This functions return value must be freed externally
char * IntChar (int iInput)
{
    char *LocalTemp = (char *) calloc(32, sizeof(char));
    IntCharEx(iInput, LocalTemp);
    return (LocalTemp);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

DWORD CharLong (const char *sInput)
{
    return (DWORD) atol(sInput);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

float CharFloat (const char *sInput)
{
    return (float) atof(sInput);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

double CharDouble (const char *sInput)
{
    return (double) atof(sInput);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int CharInt (const char *sInput)
{
    return (int) atoi(sInput);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif
